/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime.binding;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.runtime.binding.RegisteredBinding;
import team.unnamed.mocha.runtime.value.Value;

@ApiStatus.Internal
public final class JavaFieldBinding
implements RegisteredBinding {
    private static final Set<Class<?>> INLINEABLE_TYPES;
    private final Object object;
    private final Field field;
    private Supplier<Value> value;
    private boolean constant;

    JavaFieldBinding(@Nullable Object object, @Nullable Field field, @Nullable Supplier<Value> value) {
        this.object = object;
        this.field = field;
        this.value = value;
        this.evaluate();
    }

    private void evaluate() {
        if (this.value == null) {
            if (this.field == null) {
                throw new IllegalArgumentException("Either the field or its value must be given.");
            }
            int modifiers = this.field.getModifiers();
            Class<?> type = this.field.getType();
            if (Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && INLINEABLE_TYPES.contains(type)) {
                Value val = this.getFromField();
                this.value = () -> val;
                this.constant = true;
            }
        }
    }

    @Nullable
    public Field field() {
        return this.field;
    }

    public boolean constant() {
        return this.constant;
    }

    @NotNull
    public Value get() {
        if (this.value == null) {
            return this.getFromField();
        }
        return this.value.get();
    }

    @NotNull
    private Value getFromField() {
        Object val;
        Objects.requireNonNull(this.field, "field");
        try {
            val = this.field.get(this.object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not get field value.", e);
        }
        return Value.of(val);
    }

    static {
        HashSet<Class<Serializable>> inlineableTypes = new HashSet<Class<Serializable>>();
        inlineableTypes.add(Integer.TYPE);
        inlineableTypes.add(Long.TYPE);
        inlineableTypes.add(Float.TYPE);
        inlineableTypes.add(Double.TYPE);
        inlineableTypes.add(Boolean.TYPE);
        inlineableTypes.add(Byte.TYPE);
        inlineableTypes.add(Short.TYPE);
        inlineableTypes.add(Character.TYPE);
        INLINEABLE_TYPES = Collections.unmodifiableSet(inlineableTypes);
    }
}

